/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.entity.BlockEntityHelper;
import com.voxelutopia.ultramarine.world.block.entity.CenserBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Censer
extends DecorativeBlock
implements EntityBlock {
    private final Vec3 smokeOffset;

    public Censer(DecorativeBlock.Builder builder, Vec3 smokeOffset) {
        super(builder);
        this.smokeOffset = smokeOffset;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.m_21120_(pHand);
        if (item.m_150930_((Item)ItemRegistry.INCENSE.get())) {
            if (!pPlayer.m_150110_().f_35937_) {
                item.m_41774_(1);
            }
            pLevel.m_141902_(pPos, (BlockEntityType)BlockEntityRegistry.CENSER.get()).ifPresent(entity -> entity.lightIncense(pLevel, pPos, pState));
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CenserBlockEntity(pPos, pState);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (!pState.m_61138_((Property)LIT) || !((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        if (pLevel.m_46467_() % (long)(3 - pRandom.m_188503_(1)) == 0L) {
            for (int i = 0; i < 5; ++i) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pPos.m_123341_() + this.smokeOffset.f_82479_ + (double)(pRandom.m_188501_() * 0.4f) - 0.2, (double)pPos.m_123342_() + this.smokeOffset.f_82480_ + (double)(pRandom.m_188501_() * 0.1f), (double)pPos.m_123343_() + this.smokeOffset.f_82481_ + (double)(pRandom.m_188501_() * 0.4f) - 0.2, 0.0, pRandom.m_188500_() * 0.01, 0.0);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : BlockEntityHelper.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntityRegistry.CENSER.get(), CenserBlockEntity::tick);
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = super.m_5573_(pContext);
        return this.isLuminous() ? (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)) : state;
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.isLuminous()) {
            return (Boolean)state.m_61143_((Property)LIT) != false ? 4 : 0;
        }
        return 0;
    }
}

